/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal.emulator;

import com.aptana.core.util.ArrayUtil;
import com.aptana.terminal.internal.emulator.ThemedStyleMap;
import com.aptana.terminal.internal.hyperlink.HyperlinkManager;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.TextLineRenderer;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;

class ThemedTextLineRenderer
extends TextLineRenderer {
    private static ThemedStyleMap sThemedStyleMap = null;
    private HyperlinkManager hyperlinkManager;

    protected ThemedTextLineRenderer(ITextCanvasModel model, HyperlinkManager hyperlinkManager) {
        super(null, model);
        this.hyperlinkManager = hyperlinkManager;
        this.fStyleMap = ThemedTextLineRenderer.getStyleMap();
    }

    static synchronized ThemedStyleMap getStyleMap() {
        if (sThemedStyleMap == null) {
            sThemedStyleMap = new ThemedStyleMap();
        }
        return sThemedStyleMap;
    }

    protected Color getSelectionBackground() {
        Theme theme = this.getThemeManager().getCurrentTheme();
        return this.getColorManager().getColor(theme.getSelectionAgainstBG());
    }

    protected Color getSelectionForeground() {
        Theme theme = this.getThemeManager().getCurrentTheme();
        return this.getColorManager().getColor(theme.getForeground());
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    public void drawLine(ITextCanvasModel model, GC gc, int line, int x, int y, int colFirst, int colLast) {
        if (line < 0 || line >= this.getTerminalText().getHeight() || colFirst >= this.getTerminalText().getWidth() || colFirst - colLast == 0) {
            this.fillBackground(gc, x, y, this.getCellWidth() * (colLast - colFirst), this.getCellHeight());
        } else {
            colLast = Math.min(colLast, this.getTerminalText().getWidth());
            LineSegment[] segments = this.getTerminalText().getLineSegments(line, colFirst, colLast - colFirst);
            int i = 0;
            while (i < segments.length) {
                LineSegment segment = segments[i];
                Style style = segment.getStyle();
                this.setupGC(gc, style);
                String text = segment.getText();
                this.drawText(gc, x, y, colFirst, segment.getColumn(), text);
                this.drawCursor(model, gc, line, x, y, colFirst);
                ++i;
            }
            char[] chars = model.getTerminalText().getChars(line);
            Object[] links = this.hyperlinkManager.searchLineForHyperlinks(line);
            if (!ArrayUtil.isEmpty((Object[])links)) {
                Object[] objectArray = links;
                int n = links.length;
                int text = 0;
                while (text < n) {
                    Object link = objectArray[text];
                    IRegion region = link.getHyperlinkRegion();
                    String text2 = "";
                    if (chars != null) {
                        try {
                            text2 = new String(chars, region.getOffset(), region.getLength());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.underlineText(gc, x, y, colFirst, region.getOffset(), text2);
                    ++text;
                }
            }
            if (this.fModel.hasLineSelection(line)) {
                gc.setForeground(this.getSelectionForeground());
                gc.setBackground(this.getSelectionBackground());
                Point start = model.getSelectionStart();
                Point end = model.getSelectionEnd();
                if (chars == null) {
                    return;
                }
                int offset = 0;
                if (start.y == line) {
                    offset = start.x;
                }
                offset = Math.max(offset, colFirst);
                int len = end.y == line ? end.x - offset + 1 : chars.length - offset + 1;
                if ((len = Math.min(len, chars.length - offset)) > 0) {
                    String text = new String(chars, offset, len);
                    this.drawText(gc, x, y, colFirst, offset, text);
                }
            }
        }
    }
}

